mca<-function(x,y)
{
  # x<-Observed;
  # y<-Modeled;
  # cm: Value of the metric CMA
  # acm: Value of ACMA  -> the alternative CMA
  # How to call the function:
  # x<-runif(100)
  # y<-runif(100)
  #mca(x,y)
  
  n<-length(x) # %sample size of the observed data
  
  #creating empty variables to hold computed values
  A <- matrix(nrow=n, ncol=1)
  B <- matrix(nrow=n, ncol=1)
  wx <- matrix(nrow=n, ncol=1)
  ux <- matrix(nrow=n, ncol=1)
  vx <- matrix(nrow=n, ncol=1)
  Dx <- matrix(nrow=n, ncol=1)
  wy <- matrix(nrow=n, ncol=1)
  uy <- matrix(nrow=n, ncol=1)
  vy <- matrix(nrow=n, ncol=1)
  Dy <- matrix(nrow=n, ncol=1)
  tDx <- matrix(nrow=n, ncol=1)
  tDy <- matrix(nrow=n, ncol=1)
  tDxy <- matrix(nrow=n, ncol=1)
  h <- matrix(nrow=n, ncol=1)
  
  # **********************************************************
  # Penalty-based series derived from y or modeled series
  for (i in 1:n)
  {
    if (x[i]<0 & y[i]>=0) 
    {h[i]=0}
    else if (x[i]>0 & y[i]<=0)
    {h[i]=0}
    else
    {h[i]=y[i]}
  }
  for (i in 1:n)
  {
    if (x[i]==3*mean(x) & h[i]==3*mean(x)) 
    { A[i]=0
    B[i]=0}
    else
    {
      A[i] <- min((x[i]-3*mean(x))^2,(h[i]-3*mean(x))^2)
      B[i] <- max((x[i]-3*mean(x))^2,(h[i]-3*mean(x))^2)
    }
  }
  
  if (sum(B)==0 | sum(h)==0)
  { beta1<-0 }
  else
  {beta1<-(sum(A)/sum(B)) }
  
  #Taking into account the difference between the means of observed and modeled series 
  if ((mean(x)==0 & mean(h)==0) | (mean(x)==mean(h)))
  {theta1<-1}
  else
  {theta1=((min((mean(x))^2,(mean(h))^2)/max((mean(x))^2,(mean(h))^2))) }
  
  #Considering difference between standard deviations
  if (sd(x)==0 & sd(y)==0)
  { lamda1<-0}
  else if (sd(x)/sd(y)==1)
  {lamda1<-1}
  else
  {lamda1<-min(sd(x),sd(y))/max(sd(x),sd(y))}
  
  #Rescaling observed and modeled series
  for (i in 1:n)
  {
    ux[i]=sum(x>x[i]) 
    vx[i]=sum(x<x[i])
    Dx[i]=vx[i]-ux[i] 
  }    
  
  for (i in 1:n)
  {
    uy[i]=sum(y>y[i]) 
    vy[i]=sum(y<y[i])
    Dy[i]=vy[i]-uy[i] 
  }    
  
  for (i in 1:n)
  {
    tDx[i]=(Dx[i])^2
    tDy[i]=(Dy[i])^2
    tDxy[i]=Dx[i]*Dy[i]
  }
  
  #Computing non-parametric normalized linear trend slope to vary from zero to one 
  if (sum(tDx==0) | sum(tDy==0))
  { rc<-0 }
  else
  { rc<-sum(tDxy)/sqrt(sum(tDx)*sum(tDy)) }
  
  cm<-abs(rc)*beta1*theta1 #This is CMA
  acm<-abs(rc)*lamda1*theta1 #This is alternative CMA
  
  lt1 = list(cm,acm)
  return(lt1)
}  